"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentResponseDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const payment_entity_1 = require("../../../entities/payment.entity");
class PaymentResponseDto {
    id;
    amount;
    method;
    status;
    transactionId;
    paymentGateway;
    gatewayTransactionId;
    orderId;
    customerId;
    createdAt;
    updatedAt;
    processedAt;
    refundedAt;
    clientSecret;
    isRefundable;
}
exports.PaymentResponseDto = PaymentResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: '550e8400-e29b-41d4-a716-446655440000', description: 'Payment ID' }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 199.99, description: 'Payment amount' }),
    __metadata("design:type", Number)
], PaymentResponseDto.prototype, "amount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'credit_card', description: 'Payment method', enum: payment_entity_1.PaymentMethod }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "method", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'pending', description: 'Payment status', enum: payment_entity_1.PaymentStatus }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'txn_123456', description: 'Transaction ID', required: false }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "transactionId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'stripe', description: 'Payment gateway' }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "paymentGateway", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'pi_1ABCdefGHIjklMNopQRSTuvw', description: 'Gateway transaction ID', required: false }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "gatewayTransactionId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'ORD-2024-001', description: 'Order ID' }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "orderId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'Customer ID' }),
    __metadata("design:type", Number)
], PaymentResponseDto.prototype, "customerId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-01T00:00:00.000Z', description: 'Creation timestamp' }),
    __metadata("design:type", Date)
], PaymentResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-01T00:00:00.000Z', description: 'Last update timestamp' }),
    __metadata("design:type", Date)
], PaymentResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-01T00:00:00.000Z', description: 'Processed at', required: false }),
    __metadata("design:type", Date)
], PaymentResponseDto.prototype, "processedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-01T00:00:00.000Z', description: 'Refunded at', required: false }),
    __metadata("design:type", Date)
], PaymentResponseDto.prototype, "refundedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Client secret for Stripe', description: 'Client secret for payment processing', required: false }),
    __metadata("design:type", String)
], PaymentResponseDto.prototype, "clientSecret", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: true, description: 'Whether payment is refundable' }),
    __metadata("design:type", Boolean)
], PaymentResponseDto.prototype, "isRefundable", void 0);
//# sourceMappingURL=payment-response.dto.js.map